/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import cz.insophy.inplan.planning.mokos.MinimalTimeBound;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class MinimalTimeBoundSimple
implements MinimalTimeBound {
    private Map<Object, Long> absVals = Maps.newHashMap();
    private Table<Object, Object, Long> specVals = HashBasedTable.create();
    private MinimalTimeBound.BoundDefinition boundDef = new MinimalTimeBound.BoundDefinition(Long.MIN_VALUE);

    MinimalTimeBoundSimple() {
    }

    @Override
    public MinimalTimeBound.BoundDefinition getBound() {
        return this.boundDef;
    }

    @Override
    public void updateSimpleBound(Object owner, long time) {
        this.absVals.put(owner, time);
        this.actualizeBoundDef();
    }

    @Override
    public void updateCompositeBound(Object owner, Object specifier, long time) {
        this.specVals.put(owner, specifier, time);
        this.actualizeBoundDef();
    }

    @Override
    @Nonnull
    public Iterable<MinimalTimeBound.BoundInformation> getBoundInformation() {
        ArrayList<MinimalTimeBound.BoundInformation> infos = Lists.newArrayListWithCapacity(this.absVals.size() + this.specVals.size());
        for (final Map.Entry<Object, Long> entry : this.absVals.entrySet()) {
            infos.add(new MinimalTimeBound.BoundInformation(){

                @Override
                @Nonnull
                public Object getOwner() {
                    return entry.getKey();
                }

                @Override
                @Nullable
                public Object getSpecifier() {
                    return null;
                }

                @Override
                public long getTime() {
                    return (Long)entry.getValue();
                }

                @Override
                public boolean isComposite() {
                    return false;
                }
            });
        }
        for (final Table.Cell cell : this.specVals.cellSet()) {
            infos.add(new MinimalTimeBound.BoundInformation(){

                @Override
                @Nonnull
                public Object getOwner() {
                    return cell.getRowKey();
                }

                @Override
                @Nullable
                public Object getSpecifier() {
                    return cell.getColumnKey();
                }

                @Override
                public long getTime() {
                    return (Long)cell.getValue();
                }

                @Override
                public boolean isComposite() {
                    return true;
                }
            });
        }
        return infos;
    }

    private void actualizeBoundDef() {
        this.boundDef.specifiers.clear();
        long absBound = Long.MIN_VALUE;
        for (Long val : this.absVals.values()) {
            if (val <= absBound) continue;
            absBound = val;
        }
        if (this.specVals.isEmpty()) {
            this.boundDef.time = absBound;
            return;
        }
        boolean specBelowAbs = false;
        long lowestSpec = Long.MAX_VALUE;
        for (Object specifier : this.specVals.columnKeySet()) {
            long specMax = Long.MIN_VALUE;
            for (Long val : this.specVals.column(specifier).values()) {
                if (val <= specMax) continue;
                specMax = val;
            }
            if (specBelowAbs) {
                if (specMax > absBound) continue;
                this.boundDef.specifiers.add(specifier);
                continue;
            }
            if (specMax <= absBound) {
                specBelowAbs = true;
                this.boundDef.specifiers.clear();
                this.boundDef.specifiers.add(specifier);
                continue;
            }
            if (specMax < lowestSpec) {
                lowestSpec = specMax;
                this.boundDef.specifiers.clear();
                this.boundDef.specifiers.add(specifier);
                continue;
            }
            if (specMax != lowestSpec) continue;
            this.boundDef.specifiers.add(specifier);
        }
        this.boundDef.time = specBelowAbs ? absBound : lowestSpec;
    }
}

